/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_SCANNER_API_
#define SPICE3_SCANNER_API_

#include "rlTypes.h"

RL_C_API rlResult rlScannerInitConfig(rlScannerConfig* config);
RL_C_API rlResult rlScannerToStringConfig(const rlScannerConfig* config, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlScannerSetConfig(rlHandle handle, const rlScannerConfig* config);
RL_C_API rlResult rlScannerGetConfig(rlHandle handle, rlScannerConfig* config);
RL_C_API rlResult rlScannerLoadConfig(rlHandle handle);
RL_C_API rlResult rlScannerStoreConfig(rlHandle handle);
RL_C_API rlResult rlScannerGetNominalPosition(rlHandle handle, double* x, double* y, double* z);
RL_C_API rlResult rlScannerReadPositions(rlHandle handle, rlPositions* positions);
RL_C_API rlResult rlScannerReadLastPositions(rlHandle handle, rlPositions* positions);

RL_C_API rlResult rlScannerHeadFormatGetHeadCount(rlScanHeadFormat headFormat, int32_t* out);
RL_C_API rlResult rlScannerHeadFormatGetAxisCount(rlScanHeadFormat headFormat, int32_t* out);
RL_C_API rlResult rlScannerHeadFormatGetDimensions(rlScanHeadFormat headFormat, int32_t* out);
RL_C_API rlResult rlScannerHeadFormatGetAxes(rlScanHeadFormat headFormat, rlAxes* out);
RL_C_API rlResult rlScannerHeadFormatGetIndexOfAxis(rlScanHeadFormat headFormat, rlAxis axis, int32_t* out);
RL_C_API rlResult rlScannerHeadFormatGetAxisAtIndex(rlScanHeadFormat headFormat, int32_t index, rlAxis* out);
RL_C_API rlResult rlScannerHeadFormatHasOpticalZoom(rlScanHeadFormat headFormat, bool* out);
RL_C_API rlResult rlScannerHeadFormatHasAuxiliary(rlScanHeadFormat headFormat, bool* out);
RL_C_API rlResult rlScannerHeadFormatIsExtended(rlScanHeadFormat headFormat, bool* out);
RL_C_API rlResult rlScannerGetHeadBias(rlHandle handle, int32_t head, rlPoint3D* biasOut);
RL_C_API rlResult rlScannerSetHeadBias(rlHandle handle, int32_t head, rlAxes axes, double* biases, int32_t len);

#endif // SPICE3_SCANNER_API_
